% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_functions.R
\name{get_regression_table}
\alias{get_regression_table}
\title{Get regression table}
\usage{
get_regression_table(
  model,
  conf.level = 0.95,
  digits = 3,
  print = FALSE,
  default_categorical_levels = FALSE
)
}
\arguments{
\item{model}{an \code{lm()} model object}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{digits}{number of digits precision in output table}

\item{print}{If TRUE, return in print format suitable for R Markdown}

\item{default_categorical_levels}{If TRUE, do not change the non-baseline
categorical variables in the term column. Otherwise non-baseline
categorical variables will be displayed in the format
"categorical_variable_name: level_name"}
}
\value{
A tibble-formatted regression table along with lower and upper end
points of all confidence intervals for all parameters \code{lower_ci} and
\code{upper_ci}; the confidence levels default to 95\\%.
}
\description{
Output regression table for an \code{lm()} regression in "tidy" format. This function
is a wrapper function for \code{broom::tidy()} and includes confidence
intervals in the output table by default.
}
\examples{
library(moderndive)

# Fit lm() regression:
mpg_model <- lm(mpg ~ cyl, data = mtcars)

# Get regression table:
get_regression_table(mpg_model)

# Vary confidence level of confidence intervals
get_regression_table(mpg_model, conf.level = 0.99)
}
\seealso{
\code{\link[broom:reexports]{tidy()}}, \code{\link[=get_regression_points]{get_regression_points()}}, \code{\link[=get_regression_summaries]{get_regression_summaries()}}
}
