% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pt.R
\name{Pt}
\alias{Pt}
\title{Tool to computate the transition matrix for a Continuous Time Markov Chain, CTMC.}
\usage{
Pt(R, t, epsilon)
}
\arguments{
\item{R}{numeric, represents the rate matrix of a CTMC. Default value is 0.}

\item{t}{numeric, represents the length of time.}

\item{epsilon}{numeric, represents the error bound of the approximation of P(t). Default values is 0.01.}
}
\description{
\code{Pt} is used to obtain the transition matrix of a homogeneous continuous time Markov chain for a period of time of t.
}
\examples{
library(modesto)
Pt(matrix(c(0,2,3,0),2,2,byrow=TRUE),t=0.7,epsilon=0.005) # A two states CTMC example
}
\references{
Ross, S, Introduction to Probability Models, Eleven Edition. Academic Press, 2014.

Kulkarni V, Introduction to modeling and analysis of stochastic systems. Second Edition. Springer-Verlag, 2011.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
