% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lival}
\alias{lival}
\title{Living Standards Measurement Survey Albania 2012}
\format{
A data frame with 6671 rows and 26 variables
\describe{
   \item{ psu }{ primary sampling unit (psu) }
   \item{ hhid }{ unique household identifier (100*psu+hh) }
   \item{ hh }{ household number per psu }
   \item{ prefectu }{ prefecture }
   \item{ urban }{ urbanicity (Urban=1, Rural=2) }
   \item{ strat }{ stratum }
   \item{ region }{ region }
   \item{ totcons }{ total consumption of hh }
   \item{ rcons }{ real mean per capita consumption }
   \item{ rfood }{ real food consumption per capita }
   \item{ rtotnfoo }{ real non food consumption per capita }
   \item{ reduexpp }{ real education consumption per capita }
   \item{ rdurcons }{ real durable consumption per capita }
   \item{ rtotutil }{ real utilities consumption per capita}
   \item{ egap0 }{ extreme headcount poverty }
   \item{ egap1 }{ extreme poverty gap }
   \item{ egap2 }{ extreme poverty depth }
   \item{ agap0 }{ absolute headcount poverty }
   \item{ agap1 }{ absolute poverty gap }
   \item{ agap2 }{ absolute poverty depth }
   \item{ weight }{ final cross-sectional weight }
   \item{ nph }{ number of psu in stratum population }
   \item{ mph }{ number of households in stratum population }
   \item{ mphi }{ number of households in sampled psu }
   \item{ pi1 }{ psu inclusion probability }
   \item{ pi2 }{ household inclusion probability }
 }
}
\usage{
lival
}
\description{
The dataset is an extended version of the public micro data file of the LSMS 2012 of
Albania (\url{http://www.instat.gov.al/media/1547/lsms_2012_eng.rar}, accessed 14 August 2020).
Documentation of the LSMS 2012 of Albania is from the
World Bank (\url{https://microdata.worldbank.org/index.php/catalog/1970},
accessed 5 November 2020). The data set is ported to R and updated with
approximate survey design information derived from the data itself.
The units are households and the variables are expenditures on main categories,
poverty measures and structural information including weights and sample design.
}
\details{
Absolute poverty measures use a poverty line of Lek 4891 (2002 prices).
Extreme poverty measures use a poverty line where the basic nutritional needs are
difficult to meet.
The headcount poverty variable is an indicator for the income of the household \eqn{y_i}
being below the (absolute or extreme) poverty line \eqn{z}.
The poverty gap variable measures the relative distance to the poverty line: \eqn{(z-y_i)/z}.
The poverty depth variable is the square of the poverty gap variable, i.e. \eqn{[(z-y_i)/z]^2},
giving more weight to the poorer among the poor and thus describing the inequality
among the poor.

The survey design is a stratified clustered two stage design.
The primary sampling units are enumeration zones.
The strata are the crossing of prefecture and urbanicity and the allocation of the
psu sample to the strata is proportional to the number of households.
Within strata the psu are sampled with probability proportional to number of households.
Within psu a simple random sample of 8 households was selected.
The weights are calibrated to population margins.
All survey design informations except the strata and the weights are approximated
through the weights using assumptions on the design.
Since the data set has undergone data protection measures and the survey design
is approximate only, inference to the population does not yield exact results.
However, the complexity of the data and of the survey design are realistic.

The size of the household is not on the original data set.
However, the transformation \code{capita <- round(0.07527689 * totcons/rcons, 0)}
yields the number of persons in the household.
}
\note{
With R package \code{\link{survey}} a survey design object can be built with, e.g., \code{svydesign(~psu + hhid , strata= ~strat, fpc= ~pi1 +pi2,  weight= ~weight, data=lival, pps="brewer")}.
}
\examples{
data(lival)
lival$capita <- with(lival, round(0.07527689 * totcons / rcons, 0))
\dontrun{
library(survey)
lival.des <- svydesign(~psu + hhid , strata= ~strat, fpc= ~pi1 +pi2,
                      weight= ~weight, data=lival, pps="brewer")
svymean(~totcons, lival.des, deff=TRUE)
}
}
\references{
\url{http://www.instat.gov.al/media/1547/lsms_2012_eng.rar}
}
\keyword{datasets}
