% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmoezipf.R
\name{pmoezipf}
\alias{pmoezipf}
\title{Cumulative function.}
\usage{
pmoezipf(x, alpha, beta, log.p = FALSE, lower.tail = TRUE, show.plot = F)
}
\arguments{
\item{x}{Vector of positive values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{log.p}{Logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{Logical; if TRUE (default), probabilities are \eqn{P[X \leq x]}, otherwise, \eqn{P[X > x]}.}

\item{show.plot}{Logical; if TRUE shows the plot of the distibution (default = FALSE).}
}
\value{
The cumulative probability of each value in vector \code{x}.
}
\description{
Cumulative distribution function for the MOEZipf distribution
with parameters \eqn{\alpha} and \eqn{\beta}.
}
\details{
The cumulative distribution function, \eqn{F(x)}, at a given positive real value \eqn{x},
 is calcuted from the survival function \eqn{S(x)} as:


\deqn{F(x) = 1 - S(x), }

the survival function \eqn{S(x)} is equal to:

\deqn{S(x) = \frac{\beta \zeta(\alpha, x + 1)}{\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x + 1)}, \forall x > 0}
}
\examples{
pmoezipf(1:10, 2.5, 1.3)
pmoezipf(1:10, 2.5, 1.3, show.plot = TRUE)

}
\seealso{
\code{\link{smoezipf}} for the survival probability function.
}

