% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{ps}
\alias{ps}
\title{Creates a pareto set from given data}
\usage{
ps(y, minimization = TRUE, light.return = FALSE)
}
\arguments{
\item{y}{design space data}

\item{minimization}{logical representing if the set is to be minimized or not}

\item{light.return}{logical indicating if the indexes should be written on the
'ps' object}
}
\value{
S3 class object that contains information of the Pareto set
}
\description{
Return those points which are not dominated by another point in \code{y} This
is the Pareto front approximation of the design set.
}
\examples{
aps <- ps(matrix(rnorm(1:1000),ncol=2))
print(aps)

}
