% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkm.R
\name{mkm}
\alias{mkm}
\title{Multi-objective Kriging model}
\usage{
mkm(design, response, modelcontrol = NULL)
}
\arguments{
\item{design}{Numeric data.frame of the designs (decision space)}

\item{response}{Numeric data.frame of the observed responses (objectives and
constraints) at each design point.}

\item{modelcontrol}{An optional list of control parameters passed to the
\code{\link{km}} function. One can control:
\describe{
\item{\code{objective}}{(default: \code{1:ncol(response)})}
\item{\code{quiet}}{(default: \code{TRUE})}
\item{\code{formula}}{(default: \code{~1})}
\item{\code{covtype}}{(default: \code{"matern5_2"})}
\item{\code{nugget.estim}}{(default: \code{FALSE})}
\item{\code{estim.method}}{(default: \code{"MLE"})}
\item{\code{optim.method}}{(default: \code{"BFGS"})}
\item{\code{multistart}}{(default: \code{1})}
\item{\code{gr}}{(default: \code{TRUE})}
\item{\code{iso}}{(default: \code{FALSE})}
\item{\code{scaling}}{(default: \code{FALSE})}
\item{\code{type}}{(default: \code{'UK'})}
\item{\code{se.compute}}{(default: \code{TRUE})}
\item{\code{light.return}}{(default: \code{TRUE})}
\item{\code{bias.correct}}{(default: \code{FALSE})}
\item{\code{checkNames}}{(default: \code{FALSE})}
}
For more details, one can check \code{\link{km}}.}
}
\value{
S4 An object of class \code{\link{mkm-class}}
}
\description{
This function creates a multi-objective kriging model. It is based on the
\code{\link{km}} function of the \code{\link{DiceKriging}} package and
creates a structured list of \code{km} objects.
}
\examples{
# ------------------------
# The Nowacki Beam
# ------------------------
n <- 10
d <- 2
doe <- replicate(d,sample(0:n,n))/n
res <- t(apply(doe, 1, nowacki_beam))
model <- mkm(doe, res, modelcontrol = list(objective = 1:2))
}
