% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNE3d.R
\name{DNE3d}
\alias{DNE3d}
\title{Plot results of a DNE analysis of a surface}
\usage{
DNE3d(DNE_File, setRange = c(0, 0), logColors = TRUE, edgeMask = TRUE,
  outlierMask = TRUE, showEdgePts = FALSE, legend = TRUE,
  legendScale = 1, leftOffset = 0.75, fieldofview = 0)
}
\arguments{
\item{DNE_File}{An object that stores the output of the DNE
function}

\item{setRange}{User-defined range for plotting color scheme, see
Details}

\item{logColors}{Logical that log transforms the color scheme}

\item{edgeMask}{Logical that colors edge faces black to indicate their
lack of contribution to the total Dirichlet normal energy}

\item{outlierMask}{Logical that colors outlier faces dark gray to
indicate their lack of contribution to the Dirichlet normal energy}

\item{showEdgePts}{Logical that highlights the edge vertices in red
to indicate their lack of contribution ot the total Dirichlet normal energy}

\item{legend}{Logical indicating whether or not a legend
shold be displayed}

\item{legendScale}{numeric value setting the relative size of the legend similar
in function to cex}

\item{leftOffset}{numeric value between -1 and 1 setting the degree of offset
for the plotted surface to the left. Larger values set further to right.}

\item{fieldofview}{Passes an argument to par3d changing the field of
view in degrees of the resulting rgl}
}
\description{
plotting function
}
\details{
This function creates a heat map on the mesh surface
corresponding to the Dirichlet normal energy of each face calculated by
the DNE function. Hottest colors represent highest normal energy
values

Dirichlet normal energies for the faces of a mesh surface tend to be
positively skewed, with a small proportion of the faces contributing
much of the total energy for the surface. When logColors is enabled the
function colorizes based on the log transformed Dirichlet normal
energies, allowing for finer resolution between faces near the mode of
the energy per face distribution. Disabling logColors will display the
untransformed Dirichlet normal energies.

The legend will update to reflect the other arguments chosen by the
user. Colors currently display in the legend in bins, however the colors
used in the displayed mesh surface are on a continuum. Ideally, the
legend should reflect a continuous stretch of color from the lowest
calculated Dirichlet normal energy to the highest. Future versions will
adjust the legend to this more intuitive display.

By default, the function sets the lowest Dirichlet normal energy
calculated among all faces to a cool color and the highest normal energy
calculated among all faces to red, and then colors the remaining faces
on a continuous color spectrum between these two end points using
either absolute or log transformed Dirichlet normal energy values
(depending on the status of logColors). Since the scale is relative to the
energies of the input surface, visual comparisons cannot directly be
made between  multiple plots of different surfaces. The setRange
argument allows users to define the minimum and maximum of the
plotting color scheme and use it in multiple plots. This enables the
direct comparison of different surfaces to one another with red equal to
the user-defined maximum and a cool color equal to the user-defined
minimum. The user should choose reasonable bounds for the
maximum and minimum that are near the maximum and minimum
Dirichlet normal energies calculated for their surfaces. setRange will
not accept negative values.

The leftOffset value sets how far to the left the surface will appear, intended
to help avoid overlap with the legend. Defaults to 0.75.

legendScale sets the relative size of the scale in the same way cex works

fieldofview is set to a default of 0, which is an isometric projection.
Increasing it alters the degree of parallax in the perspective view, up to
a maximum of 179 degrees.
}

