% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{start_pipeline}
\alias{start_pipeline}
\title{Execute all molnet-pipeline steps sequentially}
\usage{
start_pipeline(
  layers,
  inter_layer_connections,
  drug_target_interaction,
  settings
)
}
\arguments{
\item{layers}{Named list with different network layers containing data and identifiers for
both groups. The required input format is a list with names corresponding to the content of
the respective layer (e.g., "protein"). Each named element has to contain the molecular data
and corresponding identifiers formatted by  \code{\link{make_layer}}.}

\item{inter_layer_connections}{A list with specified inter-layer connections. This list
contains one or more elements defining individual inter-layer connections created by
\code{\link{make_connection}}.}

\item{drug_target_interaction}{A list specifying drug-target interactions for drug response
score computation. The required input format of this list is created by
\code{\link{make_drug_target}}. The drug response score is calculated for all drugs contained
in this object.}

\item{settings}{A named list containing pipeline settings. The settings list has to be
initialized by \code{\link{molnet_settings}}. Items in the named list can be adjusted as desired.}
}
\value{
Data frame containing drug name and associated differential drug response score. If no
target is found for a specific drug, \code{NA} is returned as a score. If Python is not installed
or the interaction score computation fails for some other reason, NULL is returned instead.
}
\description{
This wrapper function executes all necessary steps to generate differential drug response
scores from the formatted input data. The following input data is required
(and detailed below):
* Layers of stratified molecular data.
* Additional connections between the layers.
* Interactions between drugs and nodes in the network.
* Settings for pipeline execution.
}
\details{
As this function runs through all steps of the molnet-pipeline it can take a long to complete,
especially if the supplied molecular data is in large dimensions. Several prompts will be
printed to supply information on how the pipeline is proceeding. Calculation of the interaction
score by \code{\link{interaction_score}} requires saving large-scale graphs to file and calls
a python script. This handover may take time.

Eventually a data frame is returned containing the supplied drug name and its associated
differential drug response score computed by molnet.
}
\examples{
\dontshow{
WGCNA::disableWGCNAThreads()
}
data(drug_gene_interactions)
data(layers_example)
inter_layer_connections = list(make_connection(from = 'mrna',
to = 'protein',
connect_on = 'gene_name'))
drug_target_interaction <- make_drug_target(target_molecules='protein',
interaction_table=drug_gene_interactions,
match_on='gene_name')
settings <- molnet_settings(handling_missing_data = list(default =
"pairwise.complete.obs",mrna = "all.obs"),
save_individual_graphs = FALSE,
save_combined_graphs = FALSE,
save_drug_targets = FALSE,
python_executable = "python3")

\donttest{
start_pipeline(layers_example, inter_layer_connections, drug_target_interaction, settings)
}

}
