% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_MDT_BINNING.R
\name{mdt.bin}
\alias{mdt.bin}
\title{Monotonic binning driven by decision tree}
\usage{
mdt.bin(
  x,
  y,
  g = 50,
  sc = c(NA, NaN, Inf),
  sc.method = "together",
  y.type = NA,
  min.pct.obs = 0.05,
  min.avg.rate = 0.01,
  force.trend = NA
)
}
\arguments{
\item{x}{Numeric vector to be binned.}

\item{y}{Numeric target vector (binary or continuous).}

\item{g}{Number of splitting groups for each node. Default is 50.}

\item{sc}{Numeric vector with special case elements. Default values are \code{c(NA, NaN, Inf)}.
Recommendation is to keep the default values always and add new ones if needed. Otherwise, if these values exist
in \code{x} and are not defined in the \code{sc} vector, function will report the error.}

\item{sc.method}{Define how special cases will be treated, all together or in separate bins.
Possible values are \code{"together", "separately"}.}

\item{y.type}{Type of \code{y}, possible options are \code{"bina"} (binary) and  \code{"cont"} (continuous).
If default value (\code{NA}) is passed, then algorithm will identify if \code{y} is 0/1 or continuous variable.}

\item{min.pct.obs}{Minimum percentage of observations per bin. Default is 0.05 or minimum 30 observations.}

\item{min.avg.rate}{Minimum \code{y} average rate. Default is 0.01 or minimum 1 bad case for y 0/1.}

\item{force.trend}{If the expected trend should be forced. Possible values: \code{"i"} for
increasing trend (\code{y} increases with increase of \code{x}), \code{"d"} for decreasing trend
(\code{y} decreases with decrease of \code{x}). Default value is \code{NA}.
If the default value is passed, then trend will be identified based on the sign of the Spearman correlation
coefficient between \code{x} and \code{y} on complete cases.}
}
\value{
The command \code{mdt.bin} generates a list of two objects. The first object, data frame \code{summary.tbl}
presents a summary table of final binning, while \code{x.trans} is a vector of discretized values.
In case of single unique value for \code{x} or \code{y} in complete cases (cases different than special cases),
it will return data frame with info.
}
\description{
\code{mdt.bin} implements monotonic binning driven by decision tree. As a splitting metric for continuous target
algorithm uses sum of squared errors, while for the binary target Gini index is used.
}
\examples{
suppressMessages(library(monobin))
data(gcd)
amt.bin <- mdt.bin(x = gcd$amount, y = gcd$qual)
amt.bin[[1]]
table(amt.bin[[2]])
#force decreasing trend
mdt.bin(x = gcd$amount, y = gcd$qual, force.trend = "d")[[1]]

}
