% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tpColorPlot2d.R
\name{tpColorPlot2d}
\alias{tpColorPlot2d}
\title{Color-annotated scatter plot with transparency control}
\usage{
tpColorPlot2d(x, labcol = "", xlab = "", ylab = "", tit = "",
  circlesize = rep(1.5, nrow(x)), tpfac = c(60, 255), xbound = NULL,
  ybound = NULL, centroid = FALSE, phylo = FALSE, phy, pointscale = 1)
}
\arguments{
\item{x}{a two-column matrix with rownames (usually, the species names)}

\item{labcol}{a character vector specifying species colors}

\item{xlab}{title for the x-axis}

\item{ylab}{title for the y-axis}

\item{tit}{title for the plot}

\item{circlesize}{a numeric vector that controls the centroid symbol size; defaults to 1 if \code{centroid = FALSE}}

\item{tpfac}{a numeric vector specifying the transparency level (0 to 255) for individual data points and the label mean}

\item{xbound}{range of values on the x-axis}

\item{ybound}{range of values on the y-axis}

\item{centroid}{if TRUE, plots the centroid for each species}

\item{phylo}{if TRUE, coordinates of ancestral nodes from a supplied phylogeny (\code{phy}) are estimated using \code{fastAnc}
from the \code{phytools} package, and edges between nodes are joined according to the topology specified in \code{phy}}

\item{phy}{an object of class \code{phylo} from the \code{ape} package}

\item{pointscale}{a constant for controlling the size of the plotted ancestral nodes}
}
\description{
This function enhances a typical two-dimensional scatter plot by enabling transparency control of color annotation.
In addition, it provides option for phylogenetic tree superimposition.
}
\details{
Transparency control of color-annotated data points reduces visual saturation caused by the use of solid colours,
thus allowing species centroids to be accentuated in the plot. In addition, if a user-supplied phylogeny is given,
it is superimposed onto the plot. This function depends on the \code{phytools} (Revell, 2012) and \code{ape} (Paradis et al., 2004)
packages.
}
\examples{
data(pwed_pd)
data(spcolmap)

pwed_pd_list <- matrix2list.2(pwed_pd)
lm1 <- c("V1_3","V1_5")

#scatter plot of LM1-LM3 length against LM1-LM5 length for the ventral anchors
tpColorPlot2d(pwed_pd[,colnames(pwed_pd) \%in\% lm1], labcol=spcolmap$color,
xlab=expression(paste("V1_3 ", "(", italic(mu),"m", ")")),
ylab=expression(paste("V1_5 ", "(", italic(mu),"m", ")")), centroid=TRUE)
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2015). Monogenean anchor morphometry: systematic value, phylogenetic signal and evolution.

Paradis E, Claude J & Strimmer K. (2004). APE: analyses of phylogenetics and evolution in R language. Bioinformatics 20: 289-290.

Revell LJ. (2012). phytools: An R package for phylogenetic comparative biology (and other things). Methods in Ecology and Evolution 3:217-223.
}

