% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hv.R
\name{hypervolume}
\alias{hypervolume}
\title{Hypervolume metric}
\usage{
hypervolume(x, reference, maximise = FALSE)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{\code{numeric()}\cr Reference point as a vector of numerical
values.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}
}
\value{
\code{numeric(1)}\cr A single numerical value.
}
\description{
Compute the hypervolume metric with respect to a given reference point
assuming minimization of all objectives. For 2D and 3D, the algorithm used
\citep{FonPaqLop06:hypervolume,BeuFonLopPaqVah09:tec} has \eqn{O(n \log n)}
complexity. For 4D or higher, the algorithm \citep{FonPaqLop06:hypervolume}
has \eqn{O(n^{d-2} \log n)} time and linear space complexity in the
worst-case, but experimental results show that the pruning techniques used
may reduce the time complexity even further.
}
\examples{

data(SPEA2minstoptimeRichmond)
# The second objective must be maximized
# We calculate the hypervolume of the union of all sets.
hypervolume(SPEA2minstoptimeRichmond[, 1:2], reference = c(250, 0),
            maximise = c(FALSE, TRUE))

}
\references{
\insertAllCited{}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{metrics}
