% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapShape.R
\name{morphomapShape}
\alias{morphomapShape}
\title{morphomapShape}
\usage{
morphomapShape(morphomap.core, num.land, sects_vector, cent.out = "CCA",
  delta = 0.1, side = "left")
}
\arguments{
\item{morphomap.core}{list: morphomap.core object}

\item{num.land}{numeric: number of landmarks defining each section}

\item{sects_vector}{numeric: number of sections}

\item{cent.out}{how to define the center of each section. The method allowed are "CCA" (center of cortical area), "E" (barycenter of the external outline) and "I" (barycenter of the internal outline)}

\item{delta}{pixel size used to calculate the CCA}

\item{side}{character: specify if the long bone is "left" or "right" side}
}
\value{
3D_out num.pointsx3xnum.sect array in which the external outlines are stored

3D_inn num.pointsx3xnum.sect array in which the internal outlines are stored

2D_out num.pointsx2xnum.sect array in which the external outlines are stored

2D_inn num.pointsx2xnum.sect array in which the interal outlines are stored

ALPM_inn array with the coordinates of ALPM coordinates on the external outline

ALPM_out array with the coordinates of ALPM coordinates on the internal outline

mech_length mechanical length of the long bone

start percentage of the mechanical length from which the first section is defined

end percentage of the mechanical length from which the last section is defined
}
\description{
Tool for the extraction of equiangular landmarks on the entire diaphysis
}
\examples{
\donttest{
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
inn.sur=endMesh,num.sect=61,
mech.len = mech_length, start = 0.2,end=0.8,num.points = 500)
# Shape coordinates defining as center the barycenter of the cortical area
shapeSections_CCA<-morphomapShape(rawSections,21,sects_vector=NULL, cent.out="CCA",delta=0.1)
sect1_ext<-shapeSections_CCA$`2D_out`[,,1]
sect1_int<-shapeSections_CCA$`2D_inn`[,,1]
centroid_CCA<-morphomapCentroid(rawSections$`2D_out`[,,1],rawSections$`2D_inn`[,,1], delta=0.1)
plot(sect1_ext,type="b",asp=1,xlab="x",ylab="y",main="Section 1 - CCA")
points(sect1_int,type="b",asp=1)
points(centroid_CCA[1],centroid_CCA[2],pch=19)
start<-c(centroid_CCA[1],centroid_CCA[2])
for(i in 1:21){
  to_e<-sect1_ext[i,]
  points(rbind(start,to_e),type="l")
}

# Shape coordinates defining as center the barycenter of the external perimeter
shapeSections_E<-morphomapShape(rawSections,21,sects_vector=NULL, cent.out="E",
delta=0.1, side="left")
sect1_ext<-shapeSections_E$`2D_out`[,,1]
sect1_int<-shapeSections_E$`2D_inn`[,,1]
centroid_E<-colMeans(rawSections$`2D_out`[,,1])
plot(sect1_ext,type="b",asp=1,xlab="x",ylab="y",main="Section 1 - E")
points(sect1_int,type="b",asp=1)
points(centroid_E[1],centroid_E[2],pch=19)
start<-c(centroid_E[1],centroid_E[2])
for(i in 1:21){
  to_e<-sect1_ext[i,]
  points(rbind(start,to_e),type="l")
}

# Shape coordinates defining as center the barycenter of the internal perimetershape
shapeSections_I<-morphomapShape(rawSections,21,sects_vector=NULL, cent.out="I",
delta=0.1, side="left")
sect1_ext<-shapeSections_I$`2D_out`[,,1]
sect1_int<-shapeSections_I$`2D_inn`[,,1]
centroid_I<-colMeans(rawSections$`2D_inn`[,,1])
plot(sect1_ext,type="b",asp=1,xlab="x",ylab="y",main="Section 1 - I")
points(sect1_int,type="b",asp=1)
points(centroid_I[1],centroid_I[2],pch=19)
start<-c(centroid_I[1],centroid_I[2])
for(i in 1:21){
to_e<-sect1_ext[i,]
points(rbind(start,to_e),type="l")
}
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
