% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.survFitTT.R
\name{print.survFitTT}
\alias{print.survFitTT}
\title{Print of \code{survFitTT} object}
\usage{
\method{print}{survFitTT}(x, ...)
}
\arguments{
\item{x}{An object of class \code{survFitTT}}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{print} S3 method for the \code{survFitTT} class.
It prints the underlying JAGS model and some information on the Bayesian 
inference procedure.
}
\examples{
# (1) Load the data
data(cadmium1)

# (2) Create an object of class 'survData'
cadmium1 <- survData(cadmium1)

\dontrun{
# (3) Run the survFitTT function with the log-logistic
# binomial model
out <- survFitTT(cadmium1, lcx = c(5, 10, 15, 20, 30, 50, 80),
                 quiet = TRUE)

# (4) Print the survFitTT object
print(out)
}

}
\keyword{print}
