% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morse.R
\docType{data}
\name{propiconazole_pulse_exposure}
\alias{propiconazole_pulse_exposure}
\title{Survival data set for \emph{Gammarus pulex} exposed to propiconazole
during 10 days with time-variable
exposure concentration (non-standard pulsed toxicity experiments)}
\format{A data frame with 74 observations on the following four variables:
\describe{ \item{\code{replicate}}{A vector of class \code{factor} with the
replicate code (\code{varControl}, \code{varA}, \code{varB} and \code{varC}).}
\item{\code{conc}}{A vector of class \code{numeric} with propiconazole
concentrations in \eqn{\mu mol.L^{-1}}.}
\item{\code{time}}{A vector of class \code{integer} with the time points
(in days from the beginning of the experiment \eqn{t = 0}).}
\item{\code{Nsurv}}{A vector of class \code{integer} with the number of
alive individuals at each time point for each concentration and each
replicate.}}}
\usage{
data(propiconazole_pulse_exposure)
}
\description{
Survival data set of laboratory toxicity tests with \emph{Gammarus pulex}
freshwater invertebrates exposed to several profiles of concentrations
(time-variable concentration for each time series)
of one fungicide (propiconazole) during 10 days.
}
\references{
Nyman, A.-M., Schirmer, K., Ashauer, R., (2012) Toxicokinetic-toxicodynamic
modelling of survival of \emph{Gammarus pulex} in multiple pulse exposures to
propiconazole: model assumptions, calibration data requirements and predictive
power, \emph{Ecotoxicology}, (21), 1828-1840.
}
\keyword{data}
\keyword{set}
