% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mplot.R
\name{mplot}
\alias{mplot}
\alias{mplot.TukeyHSD}
\alias{mplot.data.frame}
\alias{mplot.default}
\alias{mplot.lm}
\alias{mplot.summary.lm}
\title{Generic plotting}
\usage{
mplot(object, ...)

\method{mplot}{default}(object, ...)

\method{mplot}{lm}(object, which = c(1:3, 7), system = c("lattice",
  "ggplot2", "base"), ask = FALSE, multiplot = "package:gridExtra" \%in\%
  search(), par.settings = theme.mosaic(), level = 0.95,
  title = paste("model: ", deparse(object$call), "\\n"), rows = TRUE, ...)

\method{mplot}{data.frame}(object, format, default = format,
  system = c("lattice", "ggplot2"), show = FALSE, title = "", ...)

\method{mplot}{summary.lm}(object, system = c("lattice", "ggplot2"),
  level = 0.95, par.settings = trellis.par.get(), rows = TRUE, ...)

\method{mplot}{TukeyHSD}(object, system = c("lattice", "ggplot2"),
  ylab = "", xlab = "difference in means",
  title = "Tukey's Honest Significant Differences",
  par.settings = trellis.par.get(), ...)
}
\arguments{
\item{object}{an R object from which a plot will be constructed.}

\item{...}{additional arguments.  If \code{object} is an \code{lm}, subsets
of these arguments are passed to \code{grid.arrange} and to the
\pkg{lattice} plotting routines; in particular,
\code{nrow} and \code{ncol} can be used to control the number of rows
and columns used.}

\item{which}{a numeric vector used to select from 7 potential plots}

\item{system}{which graphics system to use (initially) for plotting (\pkg{ggplot2}
or \pkg{lattice}).  A check box will allow on the fly change of plotting system.}

\item{ask}{if TRUE, each plot will be displayed separately after the user
responds to a prompt.}

\item{multiplot}{if TRUE and \code{ask == FALSE}, all plots will be
displayed together.}

\item{par.settings}{\pkg{lattice} theme settings}

\item{level}{a confidence level}

\item{title}{title for plot}

\item{rows}{rows to show.  This may be a numeric vector,
\code{TRUE} (for all rows), or a character vector of row names.}

\item{format,default}{default type of plot to create; one of
\code{"scatter"},
\code{"jitter"},
\code{"boxplot"},
\code{"violin"},
\code{"histogram"},
\code{"density"},
\code{"frequency polygon"},
\code{"xyplot"},
or
\code{"map"}.  Unique prefixes suffice.}

\item{show}{a logical, if \code{TRUE}, the code will be displayed each time the plot is
changed.}

\item{ylab}{label for y-axis}

\item{xlab}{label for x-axis}

\item{data}{a data frame containing the variables that might be used in the plot.
Note that for maps, the data frame must contain coordinates of the polygons
comprising the map and a variable for determining which corodiantes are part
of the same region.  See \code{\link{sp2df}} for one way to create such
a data frame.  Typically \code{\link{merge}} will be used to combine the map
data with some auxilliary data to be displayed as fill color on the map, although
this is not necessary if all one wants is a map.}
}
\value{
Nothing.  Just for side effects.
}
\description{
Generic function plotting for R objects.  Currently plots exist for
\code{data.frame}s, \code{lm}s, (including \code{glm}s).
}
\examples{
if (require(mosaicData)) {
mplot( lm( width ~ length * sex, data=KidsFeet) )
mplot( lm( width ~ length * sex, data=KidsFeet), rows=2:3, which=7 )
}
\dontrun{
if (require(mosaicData)) {
mplot( HELPrct )
mplot( HELPrct, "histogram" )
}
}
if (require(mosaicData)) {
mplot(summary(lm(width ~ length * sex, data=KidsFeet)), system="ggplot")
mplot(summary(lm(width ~ length * sex, data=KidsFeet)), rows=c("sex", "length"))
mplot(summary(lm(width ~ length * sex, data=KidsFeet)), rows=TRUE)
}
if (require(mosaicData)) {
mplot(TukeyHSD( lm(age ~ substance, data=HELPrct) ) )
mplot(TukeyHSD( lm(age ~ substance, data=HELPrct) ), system="ggplot2" )
}
}

