% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqrdist.R
\name{pdist}
\alias{pdist}
\alias{xpbinom}
\alias{xpchisq}
\alias{xpf}
\alias{xpgamma}
\alias{xpgeom}
\alias{xpnbinom}
\alias{xppois}
\alias{xpt}
\title{Illustrated probability calculations from distributions}
\usage{
pdist(dist = "norm", q, plot = TRUE, verbose = FALSE, invisible = FALSE,
  digits = 4L, xlim, ylim, vlwd = NULL,
  vcol = trellis.par.get("add.line")$col, rot = 45, resolution = 5000L,
  ...)

xpgamma(...)

xpt(...)

xpchisq(...)

xpf(...)

xpbinom(...)

xppois(...)

xpgeom(...)

xpnbinom(...)
}
\arguments{
\item{dist}{a character discription of a distribution, for example 
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{q}{a vector of quantiles}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical}

\item{invisible}{a logical}

\item{digits}{the number of digits desired}

\item{xlim}{x limits}

\item{ylim}{y limits}

\item{vlwd}{width of vertical lines}

\item{vcol}{color of vertical lines}

\item{rot}{angle for rotating text indicating probability}

\item{resolution}{number of points used for detecting discreteness and generating plots.
The defaut value of 5000 should work well except for discrete distributions
that have many distinct values, especially if these values are not evenly spaced.}

\item{...}{additional arguments, including parameters of the distribution
and additional options for the plot}
}
\value{
a vector of probabilities; a plot is printed as a side effect
}
\description{
Illustrated probability calculations from distributions
}
\details{
The most general function is \code{pdist} which can work with 
any distribution for which a p-function exists.  As a convenience, wrappers are 
provided for several common distributions.
}
\examples{
pdist("norm", -2:2)
pdist("norm", seq(80,120, by=10), mean=100, sd=10)
pdist("chisq", 2:4, df=3)
pdist("f", 1, df1=2, df2=10)
pdist("gamma", 2, shape=3, rate=4)
}
\seealso{
\code{\link{qdist}}, \code{\link{xpnorm}}, \code{\link{xqnorm}}.
}

