\docType{data}
\name{Flicker}
\alias{Flicker}
\title{Critical Flicker Frequency (CFF) and Eye Color}
\format{A data frame with 19 observations on the following variables.

   \itemize{
    \item{\code{color}} {eye color: \code{Brown}, \code{Green}, or \code{Blue}}
    \item{\code{cff}} {critical flicker frequency}
  }}
\usage{
  data(Flicker)
}
\description{
  There is various flickering light in our environment; for
  instance, light from computer screens and fluorescent
  bulbs. If the frequency of the flicker is below a certain
  threshold, the flicker can be detected by the eye.
  Different people have slightly different flicker
  "threshold" frequencies (known as the "critical flicker
  frequency," or CFF). Knowing the critical threshold
  frequency below which flicker is detected can be
  important for product manufacturing as well as tests for
  ocular disease. Do people with different eye color have
  different threshold flicker sensitivity? A 1973 study
  ("The effect of iris color on critical flicker
  frequency," Journal of General Psychology [1973], 91-95)
  obtained the following data from a random sample of
  subjects.
}
\references{
  Part of the Carnegie Mellon University Online Learning
  Initiative datasets.
}
\keyword{datasets}

