% Generated by roxygen2 (4.0.0): do not edit by hand
\name{cdist}
\alias{cdist}
\title{Central portion of a distribution}
\usage{
cdist(dist, p, ..., tail = c("upper", "lower"), warn = TRUE)
}
\arguments{
  \item{dist}{a character string naming a distribution
  family (e.g., "norm"). This wil work for any family for
  which the usual d/p/q functions exist.}

  \item{p}{the proportion to be in the central region, with
  equal proportions in either "tail".}

  \item{...}{additional arguments passed to the
  distribution functions.  Typically these specify the
  parameters of the particular distribution desired.  See
  the examples.}

  \item{tail}{one of \code{"upper"} or \code{"lower"}
  specifying whether the lower or upper critical value is
  returned.}

  \item{warn}{a logical indicating whether a warning should
  be given when using a distribution that is not
  symmetric.}
}
\description{
This function determines the critial values for isolating
a central portion of a distribution with a specified probability.
This is designed to work especially well for symmteric distributions,
but it can be used with any distribution.
}
\note{
This function is still experimental and changes the input or output
formats are possible in future versions of the package.
}
\examples{
cdist( "norm", .95)
cdist( "t", c(.90, .95, .99), df=5)
cdist( "t", c(.90, .95, .99), df=50)
cdist( "t", .95, df=c(3,5,10,20) )
cdist( "norm", .95, mean=500, sd=100 )
cdist( "chisq", c(.90, .95), df=3 )
cdist( "chisq", c(.90, .95), df=3, tail="lower" )
}

