% Generated by roxygen2 (4.0.0): do not edit by hand
\docType{methods}
\name{do}
\alias{*,repeater,ANY-method}
\alias{do}
\alias{print,repeater-method}
\title{Do Things Repeatedly}
\usage{
do(n = 1L, cull = NULL, mode = "default", algorithm = 1,
  parallel = TRUE)

\S4method{print}{repeater}(x, ...)

\S4method{*}{repeater,ANY}(e1, e2)
}
\arguments{
  \item{n}{number of times to repeat}

  \item{cull}{function for culling output of objects being
  repeated.  If NULL, a default culling function is used.
  The default culling function is currently aware of
  objects of types \code{lme}, \code{lm}, \code{htest},
  \code{table}, \code{cointoss}, and \code{matrix}.}

  \item{mode}{target mode for value returned}

  \item{algorithm}{a number usd to select the algorithm
  used.  Currently numbers below 1 use an older algorithm
  and numbers >=1 use a newer algorithm which is faster in
  some situations.}

  \item{parallel}{a logical indicating whether parallel
  computation should be attempted using the \pkg{parallel}
  package (if it is installed).}

  \item{e1}{an object (in cases documented here, the result
  of running \code{do})}

  \item{e2}{an object (in cases documented here, an
  expression to be repeated)}

  \item{x}{an object used to select a method.}

  \item{...}{further arguments passed to or from other
  methods.}
}
\value{
\code{do} returns an object of class \code{repeater} which is only useful in
the context of the operator \code{*}.  See the examples.
}
\description{
\code{do()} provides a natural syntax for repetition tuned to assist
with replication and resampling methods.
}
\examples{
do(3) * rnorm(1)
do(3) * "hello"
do(3) * lm(shuffle(height) ~ sex + mother, Galton)
do(3) * anova(lm(shuffle(height) ~ sex + mother, Galton))
do(3) * 1:4
do(3) * mean(rnorm(25))
do(3) * c(sample.mean = mean(rnorm(25)))
do(3) * tally( ~sex|treat, data=resample(HELPrct))
}
\author{
Daniel Kaplan (\email{kaplan@macalaster.edu})
and Randall Pruim (\email{rpruim@calvin.edu})
}
\seealso{
\code{\link{replicate}}
}
\keyword{iteration}

