#' mosaic
#'
#' Data sets and utilities from Project MOSAIC (mosaic-web.org) used to teach mathematics, 
#' statistics, computation and modeling.  Funded by the NSF, Project MOSAIC is a 
#' community of educators working to tie together aspects of quantitative work that students 
#' in science, technology, engineering and mathematics will need in their professional lives, 
#' but which are usually taught in isolation, if at all.
#'
#'
#' @name mosaic-package
#' @aliases mosaic mosaic-package
#' @docType package
#' @title mosaic: the Project MOSAIC package
#' @author Randall Pruim (\email{rpruim@@calvin.edu}), Daniel Kaplan (\email{kaplan@@macalester.edu}), Nicholas Horton (\email{nhorton@@smith.edu})
#' @references
#' \url{http://mosaic-web.org}
#'
#' @keywords package
#' @importFrom car deltaMethod
#' @importFrom utils head modifyList
#' @importFrom stats TukeyHSD nls
#' @importFrom Hmisc xYplot
#' @importFrom gridExtra grid.arrange arrangeGrob
#' @importFrom ggdendro segment label dendro_data dendro_data.hclust
#' @importFrom reshape2 melt acast dcast
#' @import methods
#' @import dplyr
#' @import grid    
#' @import lattice
#' @import ggplot2
#' @import splines 
#' @importFrom plyr ddply
#' @import dplyr
NA
