% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ntiles}
\alias{ntiles}
\title{Create vector based on roughly equally sized groups}
\usage{
ntiles(x, n = 3, format = c("rank", "interval", "mean", "median", "center",
  "left", "right"), digits = 3)
}
\arguments{
\item{x}{a numeric vector}

\item{n}{(approximate) number of quantiles}

\item{format}{a specification of desired output format.}

\item{digits}{desired number of digits for labeling of factors.}
}
\value{
a vector.  The type of vector will depend on \code{format}.
}
\description{
Create vector based on roughly equally sized groups
}
\examples{
if (require(mosaicData)) {
tally( ~ ntiles(age, 4), data=HELPrct)
tally( ~ ntiles(age, 4, format="center"), data=HELPrct)
tally( ~ ntiles(age, 4, format="interval"), data=HELPrct)
tally( ~ ntiles(age, 4, format="left"), data=HELPrct)
tally( ~ ntiles(age, 4, format="right"), data=HELPrct)
tally( ~ ntiles(age, 4, format="mean"), data=HELPrct)
tally( ~ ntiles(age, 4, format="median"), data=HELPrct)
bwplot( i2 ~ ntiles(age, n=5, format="interval"), data=HELPrct)
}
}

