% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplot.R
\name{fortify.summary.lm}
\alias{fortify.summary.lm}
\alias{fortify.summary.glm}
\alias{fortify.TukeyHSD}
\title{Extract data from R objects}
\usage{
\method{fortify}{summary.lm}(model, data = NULL, level = 0.95, ...)

\method{fortify}{summary.glm}(model, data = NULL, level = 0.95, ...)

\method{fortify}{TukeyHSD}(model, data, order = c("asis", "pval",
  "difference"), ...)
}
\arguments{
\item{model}{an R object}

\item{data}{original data set, if needed}

\item{level}{confidence level}

\item{...}{additional arguments}

\item{order}{one of \code{"pval"}, \code{"diff"}, or \code{"asis"} determining the 
order of the \code{pair} factor, which determines the order in which the differences
are displayed on the plot.}
}
\description{
Extract data from R objects
}
\examples{
fortify(TukeyHSD(lm(age ~ substance, data=HELPrct)))
}
