% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsDoc.R
\docType{data}
\name{Whickham}
\alias{Whickham}
\title{Data from the Whickham survey}
\format{
A data frame with 1314 observations on women for the following  variables.
\itemize{
\item{\code{outcome}} {survival status after 20 years: a factor with levels \code{Alive} \code{Dead}}
\item{\code{smoker}} {smoking status at baseline: a factor with levels \code{No} \code{Yes}}
\item{\code{age}} {age (in years) at the time of the first survey}
}
}
\usage{
data(Whickham)
}
\description{
Data on age, smoking, and mortality
from a one-in-six survey of the electoral roll
in Whickham, a mixed urban and rural district near Newcastle upon
Tyne, in the UK. The survey was conducted in 1972-1974 to study
heart disease and thyroid disease.  A follow-up on those in the
survey was conducted twenty years later.
}
\details{
This dataset contains a
subset of the survey sample: women who were classified as current
smokers or as never having smoked.
The data were
synthesized from the summary description tables given
in the Appleton et al al paper.
}
\examples{
data(Whickham)

}
\references{
DR Appleton, JM French, MPJ Vanderpump.  "Ignoring a covariate: an example
of Simpson's paradox". (1996)
\emph{American Statistician}, 50(4):340-341.
}
\keyword{datasets}
