% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{recGaussian}
\alias{recGaussian}
\title{Gaussian Intermediate Recombinator}
\usage{
recGaussian(inds, lower, upper)
}
\arguments{
\item{inds}{\verb{[list of numeric]} list of two individuals to recombinate.}

\item{lower}{\verb{[numeric]} lower bounds of \code{inds} values. May have same length as
one individual or may be a single number, if the lower bounds are the same for all
values.}

\item{upper}{\verb{[numeric]} upper bounds of \code{inds} values. May have same length as
one individual or may be a single number, if the upper bounds are the same for all
values.}
}
\value{
\verb{[list of numeric]} recombined individuals.
}
\description{
Gaussian intermediate recombinator samples component-wise from a normal
distribution with mean as the component-wise mean
and standard deviation as halved components-wise absolute distance
of the two given parents.
It is applicable only for numeric representations.

See also \link[ecr:recIntermediate]{ecr::recIntermediate}.
}
\seealso{
Other operators: 
\code{\link{mutDoubleGeom}()},
\code{\link{mutGaussIntScaled}()},
\code{\link{mutGaussInt}()},
\code{\link{mutGaussScaled}()},
\code{\link{mutPolynomialInt}()},
\code{\link{mutRandomChoice}()},
\code{\link{mutUniformInt}()},
\code{\link{recIntIntermediate}()},
\code{\link{recIntSBX}()}
}
\concept{operators}
