% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosumCpts.R
\name{mosum.cpts}
\alias{mosum.cpts}
\title{MOSUM changepoints}
\usage{
mosum.cpts(x, G, G.right = NA, threshold = c("critical.value", "custom")[1],
  alpha = 0.05, threshold.custom = NULL, criterion = "epsilon",
  epsilon = 0.2, eta = 1, bootstrap = F, N_bootstrap, alpha_CI = 0.05,
  ...)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{an integer value for the moving sum bandwidth}

\item{G.right}{if \code{!is.na(G.right)}, the asymmetric bandwidth (G,G.right)
will be used;}

\item{threshold}{string indicating which threshold should be used to determine significance.
By default, \code{mosum.criticalValue} is used with significance level \code{alpha}
 Alternatively it is possible to parse a user-defined numerical value with 
 \code{threshold.custom}.}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}; use iff threshold="critical.value"}

\item{threshold.custom}{a numeric value greater than 0 for the threshold of significance;
use iff threshold="custom"}

\item{criterion}{how to decide whether an exceeding point p
is a change point,
possible values are
\itemize{
   \item{"epsilon" p is the maximum of its local exceeding environment, 
   which has at least size epsilon*G}
   \item{"eta" there is no bigger exceeding in an eta*G environment of p}
}}

\item{epsilon}{a numeric value in (0,1] for the minimal size of exceeding
environments, relative to moving sum bandwidth (iff criterion=="epsilon")}

\item{eta}{a numeric value > 0 for the minimal mutual distance of 
changes, relative to moving sum bandwidth (iff criterion=="eta")}

\item{bootstrap}{flag indicating whether bootstrap replicates of estimated changepoints
should be computed}

\item{N_bootstrap}{number of bootstrap replicates to be generated (iff bootstrap)}

\item{alpha_CI}{numeric value in (0,1), such that the (1-alpha_CI)-confidence bootstrap intervals are computed (iff bootstrap)}

\item{...}{further arguments to be parsed to call of \link[mosum]{mosum}}
}
\value{
S3 \code{mosum.cpts} object, which contains the following fields:
   \item{m}{object of class \link[mosum]{mosum} representing the underlying MOSUM statistic}
   \item{threshold,alpha,threshold.custom}{input parameter}
   \item{epsilon,eta}{input parameter}
   \item{critical.value}{the critical value of the corresponding MOSUM test}
   \item{cpts}{list of computed changepoints}
   \item{bootstrap}{input parameter}
   \item{cpts_bootstrap}{bootstrap replicates and CIs, object of class \link[mosum]{cpts.bootstrap} (iff bootstrap)}
}
\description{
Extract the changepoints found by MOSUM method.
}
\examples{
x <- piecewiseStationary_timeSeries(lengths=rep(100,3), means=c(0,5,-2), sds=rep(1,3))
m.cpts <- mosum.cpts(x, G=40)
par(mfcol=c(2,1))
plot.ts(x)
plot(m.cpts)
}
