% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{confint.multiscale.cpts}
\alias{confint.multiscale.cpts}
\title{Confidence intervals for change-points}
\usage{
\method{confint}{multiscale.cpts}(object, parm = "cpts", level = 0.05,
  N_reps = 1000, ...)
}
\arguments{
\item{object}{an object of class \code{multiscale.cpts}}

\item{parm}{specification of which parameters are to be given confidence intervals; \code{parm = 'cpts'} is supported}

\item{level}{numeric value in (0, 1), such that the \code{100(1-level)\%} confidence bootstrap intervals are computed}

\item{N_reps}{number of bootstrap replications}

\item{...}{not in use}
}
\value{
object of class \code{cpts.ci}, containing the following fields:
   \item{level,N_reps}{input parameters}
   \item{CI}{data frame of five columns, 
   containing the estimated change-points (column \code{cpt}),
   the pointwise confidence intervals 
   (columns \code{pw.left} and \code{pw.right})
   and the uniform confidence intervals 
   (columns \code{unif.left} and \code{unif.right})}
   for the corresponding change-points
}
\description{
Generate bootstrap confidence intervals for change-points.
}
\details{
See the referenced literature for further details
}
\examples{
set.seed(1337)
x <- testData(lengths=rep(100, 3), means=c(0, 3, 1), sds=rep(1, 3))
mlp <-  multiscale.localPrune(x, G=c(8, 15, 30, 70))
ci <- confint(mlp, N_reps=5000)
print(ci$CI)
}
\references{
A. Meier, C. Kirch and H. Cho (2018+)
mosum: A Package for Moving Sums in change-point Analysis.
\emph{Unpublished manuscript}.

H. Cho and C. Kirch (2018+)
Multiple change-point detection via multiscale MOSUM procedure with localised pruning.
\emph{Unpublished manuscript}.
}
