% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_signature.R
\name{lsp_signature}
\alias{lsp_signature}
\title{Creates a spatial signature}
\usage{
lsp_signature(
  x,
  type,
  window = NULL,
  neighbourhood = 4,
  threshold = 0.9,
  ordered = TRUE,
  repeated = TRUE,
  normalization = "pdf",
  wecoma_fun = "mean",
  wecoma_na_action = "replace",
  classes = NULL
)
}
\arguments{
\item{x}{Object of class \code{stars}, \code{stars_proxy}, or terra's \code{SpatRaster}. It should have one attribute (for \code{"coma"}, \code{"cove"}), two attributes (\code{"cocoma"}, \code{"cocove"}, \code{"wecoma"}, \code{"wecove"}), two or more attributes (\code{"incoma"}, \code{"incove"}), or any number of attributes suitable for user-defined functions.}

\item{type}{Type of the calculated signature. It can be \code{"coma"} (co-occurrence matrix), \code{"cove"} (co-occurrence vector), \code{"cocoma"} (co-located co-occurrence matrix), \code{"cocove"} (co-located co-occurrence vector), \code{"wecoma"} (weighted co-occurrence matrix), \code{"wecove"} (weighted co-occurrence vector), \code{"incoma"} (integrated co-occurrence matrix), \code{"incove"} (integrated co-occurrence vector), \code{"composition"} or any function that can summarize \code{stars} objects.}

\item{window}{Specifies areas for analysis. It can be either: \code{NULL}, a numeric value, or an \code{sf} object. If \code{window=NULL} calculations are performed for a whole area. If the \code{window} argument is numeric, it is a length of the side of a square-shaped block of cells. Expressed in the numbers of cells, it defines the extent of a local pattern. If an \code{sf} object is provided, each feature (row) defines the extent of a local pattern. The \code{sf} object should have one attribute (otherwise, the first attribute is used as an id).}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{threshold}{The share of NA cells (0-1) to allow metrics calculation.}

\item{ordered}{For \code{"cove"}, \code{"cocove"}, \code{"wecove"} and \code{"incove"} only. The type of pairs considered.
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}

\item{repeated}{For \code{"incove"} only. Should the repeated co-located co-occurrence matrices be used?
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}

\item{normalization}{For \code{"cove"}, \code{"cocove"}, \code{"wecove"}, \code{"incove"}, \code{"composition"}, or user-provided functions only. Should the output vector be normalized?
Either "none" or "pdf".
The "pdf" option normalizes a vector to sum to one.
The default is "pdf".}

\item{wecoma_fun}{For \code{"wecoma"} and \code{"wecove"} only. Function to calculate values from adjacent cells to contribute to exposure matrix, \code{"mean"} - calculate average values of local population densities from adjacent cells, \code{"geometric_mean"} - calculate geometric mean values of local population densities from adjacent cells, or \code{"focal"} assign a value from the focal cell}

\item{wecoma_na_action}{For \code{"wecoma"} and \code{"wecove"} only. Decides on how to behave in the presence of missing values in \code{w}. Possible options are \code{"replace"}, \code{"omit"}, \code{"keep"}. The default, \code{"replace"}, replaces missing values with 0, \code{"omit"} does not use cells with missing values, and \code{"keep"} keeps missing values.}

\item{classes}{Which classes (categories) should be analyzed? This parameter expects a list of the same length as the number of attributes in \code{x}, where each element of the list contains integer vector. The default is \code{NULL}, which means that the classes are calculated directly from the input data and all of them are used in the calculations.}
}
\value{
Object of class \code{lsp}.
It has three columns: (1) \code{id} - an id of each window.
For irregular windows, it is the values provided in the \code{window} argument,
(2) \code{na_prop} - share (0-1) of \code{NA} cells for each window,
(3) \code{signature} - a list-column containing calculated signatures
}
\description{
Calculates selected spatial signatures based on categorical raster data. It also allows for calculations for any defined regular and irregular areas. It has several built-in signatures but also allows for any user-defined functions.
}
\examples{
library(stars)

landcover = read_stars(system.file("raster/landcover2015s.tif", package = "motif"))

landcover_coma = lsp_signature(landcover, type = "coma", threshold = 0.9, window = 2000)
landcover_coma

landcover_comp = lsp_signature(landcover, type = "composition", threshold = 0.9)
landcover_comp

\donttest{
# larger data example
library(stars)

landcover = read_stars(system.file("raster/landcover2015.tif", package = "motif"))

landcover_coma = lsp_signature(landcover, type = "coma", threshold = 0.9, window = 2000)
landcover_coma

landcover_comp = lsp_signature(landcover, type = "composition", threshold = 0.9)
landcover_comp
}
}
