% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mt.R
\name{read_mt}
\alias{read_mt}
\title{Read MouseTracker raw data.}
\usage{
read_mt(file, columns = "all", add_trialid = FALSE,
  add_filename = FALSE)
}
\arguments{
\item{file}{a character string specifying the filename of the .mt file.}

\item{columns}{either 'all' or a character vector specifying the to be 
extracted variables. Defaults to 'all' in which case all existing variables
will be extracted.}

\item{add_trialid}{boolean specifying whether an additional column containing
the trial number should be added.}

\item{add_filename}{boolean specifying whether an additional column 
containing the file name should be added.}
}
\value{
A \link{data.frame} with one row per trial. Variables are ordered
  according to columns, x-coordinates, y-coordinates, and timestamps.
}
\description{
\code{read_mt} reads raw data that was collected using 
\href{http://www.mousetracker.org/}{MouseTracker} (Freeman & Ambady, 2010) 
and stored as a file in the ".mt" format. If multiple files should be read 
into R, \code{read_mt} can be used in combination with the 
\link[readbulk]{read_bulk} function from the
\href{http://pascalkieslich.github.io/readbulk/}{readbulk} package (see 
Examples). After reading the data into R, \link{mt_import_wide} can be used 
to prepare the trajectory data for analyses using the mousetrap library. The 
current version of \code{read_mt} has been tested with data from MouseTracker
Version 2.84 - but please be sure to double-check.
}
\examples{
\dontrun{
# Read a single raw data file from MouseTracker
# (stored in the current working directory)
mt_data_raw <- read_mt("example.mt")

# Use read_bulk to read all raw data files ending with ".mt" that are
# stored in the folder "raw_data" (in the current working directory)
library(readbulk)
mt_data_raw <- read_bulk("raw_data", fun=read_mt, extension=".mt")

# Import the data into mousetrap
mt_data <- mt_import_wide(mt_data_raw)
}


}
\references{
Freeman, J. B., & Ambady, N. (2010). MouseTracker: Software for 
  studying real-time mental processing using a computer mouse-tracking
  method. \emph{Behavior Research Methods, 42}(1), 226-241.
}
\seealso{
\link[readbulk]{read_bulk} from the \code{readbulk} package for reading and 
combining multiple raw data files.

\link{mt_import_wide} to prepare the imported data for analyses in mousetrap.
}
\author{
Dirk U. Wulff (\email{dirk.wulff@gmail.com})
}
