
#' Example data simulation
#'
#' Generate the file \code{data/example.RData}, used in other functions' examples and unit tests.
#'
#' @export

exGen <- function()
{
  set.seed(1)

  # simulate data
  nbAnimals <- 2
  nbStates <- 2
  nbCovs <- 2
  mu<-c(15,50)
  sigma<-c(10,20)
  angleMean <- c(pi,0)
  kappa <- c(0.7,1.5)
  stepPar <- c(mu,sigma)
  anglePar <- c(angleMean,kappa)
  stepDist <- "gamma"
  angleDist <- "vm"
  zeroInflation <- FALSE
  obsPerAnimal <- c(50,100)

  simPar <- list(nbAnimals=nbAnimals,nbStates=nbStates,angleMean=angleMean,stepDist=stepDist,
                 angleDist=angleDist,zeroInflation=zeroInflation)

  data <- simData(nbAnimals=nbAnimals,nbStates=nbStates,stepDist=stepDist,angleDist=angleDist,
                  stepPar=stepPar,anglePar=anglePar,nbCovs=nbCovs,zeroInflation=zeroInflation,
                  obsPerAnimal=obsPerAnimal)

  # estimate model
  mu0 <- c(20,70)
  sigma0 <- c(10,30)
  kappa0 <- c(1,1)
  stepPar0 <- c(mu0,sigma0)
  anglePar0 <- kappa0
  formula <- ~cov1+cos(cov2)
  nbCovs <- length(attr(terms(formula), "term.labels"))

  beta0 <- matrix(c(rep(-1.5,nbStates*(nbStates-1)),rep(0,nbStates*(nbStates-1)*nbCovs)),
                  nrow=nbCovs+1,byrow=TRUE)
  delta0 <- rep(1,nbStates)/nbStates

  par0 <- list(stepPar0=stepPar0,anglePar0=anglePar0,formula=formula,nbCovs=nbCovs,beta0=beta0,
               delta0=delta0)

  m <- fitHMM(data=data,nbStates=nbStates,stepPar0=stepPar0,anglePar0=anglePar0,beta0=beta0,
                delta0=delta0,formula=formula,stepDist=stepDist,angleDist=angleDist,
                angleMean=angleMean)

  example <- list(data=data,m=m,simPar=simPar,par0=par0)
  save(example,file="data/example.RData")
}

# Roxygen documentation for the data file "data/example.RData"

#' Example dataset
#'
#' This data is generated by the function \code{\link{exGen}}, and used in the examples and tests of
#' other functions to keep them as short as possible.
#'
#' It is a list of the following objects:
#' \itemize{
#' \item \code{data} A \code{\link{moveData}} object
#' \item \code{m} A \code{\link{moveHMM}} object
#' \item \code{simPar} The parameters used to simulate \code{data}
#' \item \code{par0} The initial parameters in the optimization to fit \code{m}
#' }
#'
#' @name example
#' @usage example
#' @docType data
NULL
