% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viterbi.R
\name{viterbi}
\alias{viterbi}
\title{Viterbi algorithm}
\usage{
viterbi(m)
}
\arguments{
\item{m}{An object \code{moveHMM}}
}
\value{
The sequence of most probable states.
}
\description{
For a given model, reconstructs the most probable states sequence,
using the Viterbi algorithm.
}
\examples{
# m is a moveHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

# reconstruction of states sequence
states <- viterbi(m)

}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}
