% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_formats.R
\name{get_formats}
\alias{get_formats}
\title{Get all available output file formats}
\usage{
get_formats(tool = "auto")
}
\arguments{
\item{tool}{character. Default is "auto" to return all available formats. If set to either 'convert', 'ffmpeg' or 'avconv', the output formats made available by one of these specific library tools are returned.}
}
\value{
A character vector containing available output formats. Each vector element can serve as input to the \code{out_format} argument of \code{\link{animate_move}}.
}
\description{
\code{get_formats} returns all available file formats that can be used with \code{\link{animate_move}} (\code{out_format}). The available output formats depend on the additional libraries that are installed on your system (see \code{\link{get_libraries}}).
}
\examples{
\dontrun{
#Get all formats available from the currently installed libraries
formats <- get_formats()
print(formats)

#For example, use the output as input to animate_move() out_format argument
out_format <- formats[1]
}

#Get formats provided by specifc tool
formats <- get_formats(tool = "convert")

}
\seealso{
\code{\link{get_libraries}}
}
\author{
Jakob Schwalb-Willmann
}
