% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.mpoly.R
\name{deriv.mpoly}
\alias{deriv.mpoly}
\title{Compute partial derivatives of a multivariate polynomial.}
\usage{
\method{deriv}{mpoly}(expr, var, ...)
}
\arguments{
\item{expr}{an object of class mpoly}

\item{var}{character - the partial derivative desired}

\item{...}{any additional arguments}
}
\value{
An object of class mpoly or mpolyList.
}
\description{
This is a deriv method for mpoly objects.  It does not call the
deriv function (from package stats).
}
\examples{
m <- mp('x y + y z + z^2')
deriv(m, 'x')
deriv(m, 'y')
deriv(m, 'z')
deriv(m, c('x','y','z'))
deriv(m, 'a')
is.mpoly(deriv(m, 'x'))
is.mpolyList( deriv(m, c('x','y','z')) )
}
