% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dctMatrix}
\alias{dctMatrix}
\title{Create a n-by-n discrete cosine transform matrix.}
\usage{
dctMatrix(n)
}
\arguments{
\item{n}{Dimension for the DCT matrix.}
}
\value{
The n-by-n DCT matrix.
}
\description{
The discrete cosine transform (DCT) matrix for a given dimension n is
calculated.
}
\details{
The function can be used for 1D- or 2D-DCT transforms of data.
\itemize{
\item \strong{1D:} Let \code{Q} be a m-by-n matrix with some data. \code{D} is a
m-by-m DCT matrix created by \code{dctMatrix(m)}. Then \code{D \%*\% Q} returns the
discrete cosine transform of the columns of Q. \code{t(D) \%*\% Q} returns the
inverse DCT of the columns of Q. As D is orthogonal, \code{solve(D) = t(D)}.
\item \strong{2D:} Let \code{Q} be a m-by-n matrix with some data. \code{D_m} is a
m-by-m DCT matrix created by \code{dctMatrix(m)}, \code{D_n} a n-by-n DCT matrix
created by \code{dctMatrix(n)}. \code{D_m \%*\% Q \%*\% t(D_n)} computes the 2D-DCT
of Q. The inverse 2D-DCT of Q can be computed via \cr \code{t(D_mm) \%*\% DCT_Q \%*\% D_n}.
D_m transforms along columns, D_n along rows. Since D is orthogonal, \code{solve(D) = t(D)}.
}
It can be faster to use \code{dctMatrix} than using a direct transformation,
especially when calculating several DCT's.
}
\examples{
D <- dctMatrix(5)
}
