% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_code.R
\name{mr_geo_code}
\alias{mr_geo_code}
\title{Geocode with Marineregions}
\usage{
mr_geo_code(place, like = TRUE, fuzzy = FALSE, ...)
}
\arguments{
\item{place}{(character) a place name}

\item{like}{(logical) adds a percent-sign before and after place value
(a SQL LIKE function). Default: \code{TRUE}}

\item{fuzzy}{(logical) Uses Levenshtein query to find nearest matches.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
If no results, an empty list. If results found, a data.frame with the columns:
\itemize{
 \item MRGID (integer)
 \item gazetteerSource (character)
 \item placeType (character)
 \item latitude (numeric)
 \item longitude (numeric)
 \item minLatitude (numeric)
 \item minLongitude (numeric)
 \item maxLatitude (numeric)
 \item maxLongitude (numeric)
 \item precision (numeric)
 \item preferredGazetteerName (character)
 \item preferredGazetteerNameLang (character)
 \item status (character)
 \item accepted (integer)
}
}
\description{
Geocode with Marineregions
}
\examples{
\dontrun{
# search for 'oost', like=TRUE, and not fuzzy
mr_geo_code(place = "oost", like = TRUE, fuzzy = FALSE)

# search for 'oost', like=FALSE, and not fuzzy
mr_geo_code(place = "oost", like = FALSE, fuzzy = FALSE)

# search for 'oost', like=FALSE, and fuzzy
mr_geo_code(place = "oost", like = FALSE, fuzzy = TRUE)

# search for 'oost', like=TRUE, and fuzzy
mr_geo_code(place = "oost", like = TRUE, fuzzy = TRUE)

# search for 'ast', like=TRUE, and fuzzy
mr_geo_code(place = "ast", like = TRUE, fuzzy = TRUE)
}
}

