% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obis_eez_id.R
\name{mr_obis_eez_id}
\alias{mr_obis_eez_id}
\title{Get OBIS EEZ id}
\usage{
mr_obis_eez_id(x)
}
\arguments{
\item{x}{(character) An Exclusive Economic Zone name}
}
\value{
An integer EEZ ID if a match found in list of EEZ's, or
\code{NULL} if no match found.
}
\description{
Get OBIS EEZ id
}
\details{
internally we use the OBIS API to retrieve an EEZ id.

Matching internally is case insensitive, as we convert your input and match
against EEZ names that are all lower case.
}
\examples{
\dontrun{
# You can get EEZ names via the mr_names() function
(res <- mr_names('MarineRegions:eez_boundaries'))
mr_obis_eez_id(res$eez1[19])

# Or pass in a name
mr_obis_eez_id("Bulgarian Exclusive Economic Zone")

# case doesn't matter
mr_obis_eez_id("bulgarian exclusive economic zone")

# No match, gives NULL
mr_obis_eez_id("stuff things")
}
}

