% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaenet-inspect.R
\name{coef.msaenet}
\alias{coef.msaenet}
\title{Extract Model Coefficients}
\usage{
\method{coef}{msaenet}(object, ...)
}
\arguments{
\item{object}{An object of class \code{msaenet} produced
by \code{\link{aenet}}, \code{amnet}, \code{asnet},
\code{\link{msaenet}}, \code{\link{msamnet}}, or \code{\link{msasnet}}.}

\item{...}{Additional parameters for \code{\link{coef}} (not used).}
}
\value{
A numerical vector of model coefficients.
}
\description{
Extract model coefficients from the final model in msaenet model objects.
}
\examples{
dat = msaenet.sim.gaussian(
  n = 150, p = 500, rho = 0.6,
  coef = rep(1, 5), snr = 2, p.train = 0.7,
  seed = 1001)

msaenet.fit = msaenet(
  dat$x.tr, dat$y.tr,
  alphas = seq(0.2, 0.8, 0.2),
  nsteps = 3L, seed = 1003)

coef(msaenet.fit)
}
\author{
Nan Xiao <\url{https://nanx.me}>
}

