% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_tts_auth.R
\name{ms_get_tts_token}
\alias{ms_get_tts_token}
\alias{ms_auth_url}
\alias{ms_expired_token}
\title{Get Microsoft Text To Speech (TTS) or Cognitive
Services Token from API Key}
\usage{
ms_get_tts_token(api_key = NULL, region = ms_regions())

ms_auth_url(region = ms_regions())

ms_expired_token(token = NULL)
}
\arguments{
\item{api_key}{Microsoft Cognitive Services API key}

\item{region}{Subscription region for your key.
See
\url{https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/rest-apis#text-to-speech}}

\item{token}{An authentication of class \code{token},
likely from \code{\link{ms_get_tts_token}}}
}
\value{
A list of the request, and token
}
\description{
Get Microsoft Text To Speech (TTS) or Cognitive
Services Token from API Key
}
\examples{
if (ms_valid_tts_key()) {
   token = ms_get_tts_token()
}
}
