\name{nmod.msgl}
\alias{nmod.msgl}
\title{Returns the number of models in a msgl object}
\usage{
  \method{nmod}{msgl} (object, ...)
}
\arguments{
  \item{object}{a msgl object}

  \item{...}{not used}
}
\value{
  the number of models in \code{object}
}
\description{
  Returns the number of models in a msgl object
}
\examples{
data(SimData)
x <- sim.data$x
classes <- sim.data$classes
lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x, classes, alpha = .5, lambda = lambda)

# the number of models
nmod(fit)
}
\author{
  Martin Vincent
}

