% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_translations.R
\name{check_translation}
\alias{check_translation}
\alias{check_translations}
\alias{install_translations}
\title{Install translations}
\usage{
check_translation(language, pkg = ".", domain = "R", strictPlural = FALSE,
  verbose = getOption("verbose"))

check_translations(pkg = ".", strictPlural = FALSE,
  verbose = getOption("verbose"))

install_translations(pkg = ".", verbose = getOption("verbose"))
}
\arguments{
\item{language}{A character string specifying a language.}

\item{pkg}{The directory of an R package to extract diagnostic messages from. Path is passed to \code{\link[devtools]{as.package}}.}

\item{domain}{A character string specifying the \dQuote{domain} of the messages. Either \dQuote{R} (the default) or \dQuote{C}. This is case insensitive.}

\item{strictPlural}{A logical indicating whether to compare formats of singular and plural forms in a strict way. See \code{\link[tools]{checkPoFile}}.}

\item{verbose}{A logical. Should the function be chatty?}
}
\value{
\code{check_translation} returns an object of class \dQuote{check_po_files}; \code{check_translations} returns a list of such objects. \code{install_translations} returns a logical TRUE, if successful.
}
\description{
Check and install message translations
}
\details{
\code{check_translation} checks a specific translation file. \code{check_translations} checks all translations in the /po directory. These are just wrappers around \code{\link[tools]{checkPoFile}}.

\code{install_translations} performs a reduced set of the functionality described in \code{\link[tools]{update_pkg_po}}.
}
\note{
These functions require that gettext is installed on your system.
}
\examples{
\dontrun{
  # check translations
  check_translations()
  
  # install translations
  install_translations()
}
}
\seealso{
\code{\link{use_localization}}, \code{\link{make_translation}}
}

