% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.msm}
\alias{tidy.msm}
\title{Tidy the parameter estimates from an msm model}
\usage{
\method{tidy}{msm}(x, ...)
}
\arguments{
\item{x}{Object returned by \code{\link{msm}}, representing a fitted
multi-state model.}

\item{...}{Other arguments (currently unused).}
}
\value{
A "tibble", with one row for each parameter and the following
columns describing the parameter.
\itemize{
\item \code{parclass}: Class of parameters: \code{intens} (transition intensities), \code{hr}
(hazard ratios representing effects of covariates on intensities), and
their transformed versions \code{logintens} (log intensities) and \code{loghr} (log
hazard ratios).

For "misclassification" models fitted with the \code{ematrix} argument to \code{msm},
other classes of parameters include \code{misc} (misclassification
probabilities), \code{logitmisc} (misclassification log odds), \code{or_misc} and
\code{logor_misc} (effects of covariates on misclassification probabilities, as
odds ratios or log odds ratios, with the first state as the reference
category).

For hidden Markov models fitted with the \code{hmodel} argument to \code{msm}, the
parameter class called \code{hmm} comprises the parameters of the distributions
of the outcome conditionally on the hidden state.  Covariates on the
location parameter of these distributions are included in class \code{hmmcov}.
If initial state occupancy probabilities are estimated, these are included
in class \code{initp} (or \code{initlogodds} for the log odds transforms of these),
and any covariates on these probabilities are included in class \code{initpcov}.
\item \code{state}: Starting state of the transition for transition intensities, and
true state for misclassification probabilities or hidden Markov model parameters.
\item \code{tostate}: Ending state of the transition for transition intensities, and
observed state for misclassification probabilities
\item \code{term}: Name of the covariate for covariate effects, or "baseline" for the
baseline intensity or analogous parameter value.
Note that the "baseline" parameters are the parameters with covariates
set to their mean values in the data (stored in e.g. \code{x$qcmodel$covmeans}),
unless \code{msm} was called with \code{center=FALSE}.
\item \code{estimate}, \code{std.error}, \code{conf.low}, \code{conf.high}:  Parameter estimate,
standard error, and lower and upper confidence limits.
\item \code{statistic}, \code{p.value}: For covariate effects, the Z-test statistic and p-value
for a test of the null hypothesis that the covariate effect is zero, based
on the estimate and standard error.
}
}
\description{
Tidy the parameter estimates from an msm model
}
