% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silhouette.km.R
\name{silhouette.km}
\alias{silhouette.km}
\title{Silhouettes for \eqn{K}-Means Clustering}
\usage{
silhouette.km(x, centers)
}
\arguments{
\item{x}{The \eqn{N \times P}{N x P} data matrix.}

\item{centers}{The \eqn{K \times P}{K x P} matrix of centers (means) for the
\eqn{K} Clusters, row \eqn{k} being the center for
cluster \eqn{K}.}
}
\value{
The \eqn{n}-vector of silhouettes, indexed by the observations'
indices.
}
\description{
Find the silhouettes (12.9) for K-means clustering from the data and and the
groups' centers.
}
\details{
This function is a bit different from the silhouette function in the cluster
package, [Maechler et al., 2005].
}
\examples{

# Uses sports data.
data(sportsranks)

# Obtain the K-means clustering for sports ranks.
kms <- kmeans(sportsranks, centers = 5, nstart = 10)

# Silhouettes
sil <- silhouette.km(sportsranks, kms$centers)

}
