% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mssm}
\alias{plot.mssm}
\title{Plot Predicted State Variables for mssm Object.}
\usage{
\method{plot}{mssm}(x, y, qs = c(0.05, 0.95), do_plot = TRUE,
  which_weights = c("filter", "smooth"), ...)
}
\arguments{
\item{x}{an object of class \code{mssm}.}

\item{y}{un-used.}

\item{qs}{two-dimensional numeric vector with bounds of the prediction
interval.}

\item{do_plot}{\code{TRUE} to create a plot with the mean and quantiles.}

\item{which_weights}{character of which weights to use. Either
\code{"filter"} for filter weights or \code{"smooth"} for smooth for
smooth weights. The latter requires that \code{smooth} element has
been used.}

\item{...}{un-used.}
}
\value{
List with means and quantiles.
}
\description{
Plots the predicted mean and pointwise prediction interval of the state
variables for the filtering distribution or smoothing distribution.
}
\examples{
if(require(Ecdat)){
  # load data and get object to perform particle filtering
  data("Gasoline", package = "Ecdat")

  library(mssm)
  ll_func <- mssm(
    fixed = lgaspcar ~ factor(country) + lincomep + lrpmg + lcarpcap,
    random = ~ 1, family = Gamma("log"), data = Gasoline, ti = year,
    control = mssm_control(N_part = 1000L, n_threads = 1L))

  # run particle filter
  cfix <- c(0.612, -0.015, 0.214, 0.048, -0.013, -0.016, -0.022, 0.047,
            -0.046, 0.007, -0.001, 0.008, -0.117, 0.075, 0.048, -0.054, 0.017,
            0.228, 0.077, -0.056, -0.139)
  pf <- ll_func$pf_filter(
    cfix = cfix, Q = as.matrix(2.163e-05), F. = as.matrix(0.9792),
    disp = 0.000291)

  # plot predicted values and prediction intervals
  plot(pf)
  plot(pf, qs = c(.01, .99))
  pf <- ll_func$smoother(pf)
  plot(pf, which_weights = "smooth")
}
}
