% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.MarkovTest.R
\name{print.MarkovTest}
\alias{print.MarkovTest}
\title{Print method for a MarkovTest object}
\usage{
\method{print}{MarkovTest}(x, ...)
}
\arguments{
\item{x}{Object of class 'markovTest', as obtained by call to
\code{\link{MarkovTest}}}

\item{\dots}{Further arguments to print}
}
\value{
No return value
}
\description{
Print method for an object of class 'MarkovTest'
}
\examples{

\dontrun{
# Example provided by the prothrombin data
data("prothr")
# Apply Markov test to grid of monthly time points over the first 7.5 years
year <- 365.25
month <- year / 12
grid <- month * (1:90)
# Markov test for transition 1 (wild bootstrap based on 25 replications for brevity)
MT <- MarkovTest(prothr, id = "id", transition = 1,
                 grid = grid, B = 25)
MT
}

}
\seealso{
\code{\link{MarkovTest}}
}
\author{
Hein Putter \email{H.Putter@lumc.nl}
}
\keyword{hplot}
