% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata.io.R
\name{write.mudata}
\alias{read.mudata}
\alias{read.mudata.json}
\alias{read.mudata.zip}
\alias{write.mudata}
\alias{write.mudata.json}
\alias{write.mudata.zip}
\title{Read/Write mudata objects}
\usage{
write.mudata(md, filename, ...)

read.mudata(filename, ...)

write.mudata.zip(md, filename, overwrite = FALSE, expand.tags = TRUE,
  validate = TRUE, ...)

read.mudata.zip(filename, validate = TRUE, expand.tags = TRUE,
  retype = TRUE, load = c("data", "locations", "params", "datasets",
  "columns"), ...)

write.mudata.json(md, filename, overwrite = FALSE, expand.tags = TRUE,
  validate = TRUE, ...)

read.mudata.json(filename, validate = TRUE, expand.tags = TRUE,
  retype = TRUE, load = c("data", "locations", "params", "datasets",
  "columns"), ...)
}
\arguments{
\item{md}{a mudata object}

\item{filename}{file to read/write (can also be a directory)}

\item{...}{passed to read/write.csv}

\item{overwrite}{Pass \code{TRUE} to overwrite if \code{zipfile} already exists.}

\item{expand.tags}{flag to expand tags to columns}

\item{validate}{flag to validate mudata object upon read or before write}

\item{retype}{Pass \code{TRUE} to retype columns based on the 'type' column of the 'columns'
table.}

\item{load}{a list of csv files (without the .csv extension) to load from the source.}
}
\description{
Read/Write mudata objects
}
\examples{
data(kentvillegreenwood)
# read/write to zip
outfile <- tempfile(fileext=".zip")
write.mudata(kentvillegreenwood, outfile)
md <- read.mudata(outfile)
md <- read.mudata(outfile, retype=TRUE)
plot(subset(md, params=c("meantemp", "maxtemp")))
unlink(outfile)

# read/write to JSON
outfile <- tempfile(fileext=".json")
write.mudata(kentvillegreenwood, outfile)
md <- read.mudata(outfile)
md <- read.mudata(outfile, retype=TRUE)
plot(subset(md, params=c("meantemp", "maxtemp")))
unlink(outfile)

}

