% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_uc_om_sel.R
\name{adjust_uc_om_sel}
\alias{adjust_uc_om_sel}
\title{Adust for uncontrolled confounding, outcome misclassification, and selection
bias.}
\usage{
adjust_uc_om_sel(
  data_observed,
  u_model_coefs = NULL,
  y_model_coefs = NULL,
  u0y1_model_coefs = NULL,
  u1y0_model_coefs = NULL,
  u1y1_model_coefs = NULL,
  s_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data_observed}{Object of class \code{data_observed} corresponding to the
data to perform bias analysis on.}

\item{u_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(U=1)) = &alpha;<sub>0</sub> + &alpha;<sub>1</sub>X + &alpha;<sub>2</sub>Y, }}{\eqn{logit(P(U=1)) = \alpha_0 + \alpha_1 X + \alpha_2 Y, }}
where \emph{U} is the binary unmeasured confounder, \emph{X} is the
exposure, and \emph{Y} is the binary true outcome.
The number of parameters therefore equals 3.}

\item{y_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(Y=1)) = &delta;<sub>0</sub> + &delta;<sub>1</sub>X + &delta;<sub>2</sub>Y* + &delta;<sub>2+j</sub>C<sub>j</sub>, }}{\eqn{logit(P(Y=1)) = \delta_0 + \delta_1 X + \delta_2 Y^* + \delta_{2+j} C_j, }}
where \emph{Y} represents binary true outcome, \emph{X} is the
exposure, \emph{Y}* is the binary misclassified outcome, \emph{C}
represents the vector of measured confounders (if any),
and \emph{j} corresponds to the number of measured
confounders. The number of parameters therefore equals 3 + \emph{j}.}

\item{u0y1_model_coefs}{The regression coefficients corresponding to the
model:
\ifelse{html}{\out{log(P(U=0,Y=1)/P(U=0,Y=0)) = &gamma;<sub>2,0</sub> + &gamma;<sub>2,1</sub>X + &gamma;<sub>2,2</sub>Y* + &gamma;<sub>2,2+j</sub>C<sub>j</sub>, }}{\eqn{log(P(U=0,Y=1)/P(U=0,Y=0)) = \gamma_{2,0} + \gamma_{2,1} X + \gamma_{2,2} Y^* + \gamma_{2,2+j} C_j, }}
where \emph{U} is the binary unmeasured confounder,
\emph{Y} is the binary true outcome,
\emph{X} is the exposure, \emph{Y}* is the binary misclassified outcome,
\emph{C} represents the vector of measured confounders (if any), and
\emph{j} corresponds to the number of measured confounders.
The number of parameters therefore equals 3 + \emph{j}.}

\item{u1y0_model_coefs}{The regression coefficients corresponding to the
model:
\ifelse{html}{\out{log(P(U=1,Y=0)/P(U=0,Y=0)) = &gamma;<sub>1,0</sub> + &gamma;<sub>1,1</sub>X + &gamma;<sub>1,2</sub>Y* + &gamma;<sub>1,2+j</sub>C<sub>j</sub>, }}{\eqn{log(P(U=1,Y=0)/P(U=0,Y=0)) = \gamma_{1,0} + \gamma_{1,1} X + \gamma_{1,2} Y^* + \gamma_{1,2+j} C_j, }}
where \emph{U} is the binary unmeasured confounder,
\emph{Y} is the binary true outcome,
\emph{X} is the exposure, \emph{Y}* is the binary misclassified outcome,
\emph{C} represents the vector of measured confounders (if any), and
\emph{j} corresponds to the number of measured confounders.
The number of parameters therefore equals 3 + \emph{j}.}

\item{u1y1_model_coefs}{The regression coefficients corresponding to the
model:
\ifelse{html}{\out{log(P(U=1,Y=1)/P(U=0,Y=0)) = &gamma;<sub>3,0</sub> + &gamma;<sub>3,1</sub>X + &gamma;<sub>3,2</sub>Y* + &gamma;<sub>3,2+j</sub>C<sub>j</sub>, }}{\eqn{log(P(U=1,Y=1)/P(U=0,Y=0)) = \gamma_{3,0} + \gamma_{3,1} X + \gamma_{3,2} Y^* + \gamma_{3,2+j} C_j, }}
where \emph{U} is the binary unmeasured confounder,
\emph{Y} is the binary true outcome,
\emph{X} is the exposure, \emph{Y}* is the binary misclassified outcome,
\emph{C} represents the vector of measured confounders (if any), and
\emph{j} corresponds to the number of measured confounders.
The number of parameters therefore equals 3 + \emph{j}.}

\item{s_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(S=1)) = &beta;<sub>0</sub> + &beta;<sub>1</sub>X + &beta;<sub>2</sub>Y* + &beta;<sub>2+j</sub>C<sub>2+j</sub>, }}{\eqn{logit(P(S=1)) = \beta_0 + \beta_1 X + \beta_2 Y^* + \beta_{2+j} C_j, }}
where \emph{S} represents binary selection, \emph{X} is the exposure,
\emph{Y}* is the binary misclassified outcome, \emph{C} represents
the vector of measured confounders (if any), and \emph{j} corresponds
to the number of measured confounders.
The number of parameters therefore equals 3 + \emph{j}.}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
effect of the exposure on the outcome and the second item is the
confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_uc_om_sel} returns the exposure-outcome odds ratio and
confidence interval, adjusted for uncontrolled confounding, outcome
misclassificaiton, and selection bias. Two different options for the bias
parameters are availale here: 1) parameters from separate models
of \emph{U} and \emph{Y} (\code{u_model_coefs} and \code{y_model_coefs})
or 2) parameters from a joint model of \emph{U} and \emph{Y}
(\code{u1y0_model_coefs}, \code{u0y1_model_coefs}, and
\code{u1y1_model_coefs}). Both approaches require \code{s_model_coefs}.
}
\details{
Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
df <- data_observed(
  data = df_uc_om_sel,
  exposure = "X",
  outcome = "Ystar",
  confounders = c("C1", "C2", "C3")
)
# Using u_model_coefs, y_model_coefs, s_model_coefs -------------------------
adjust_uc_om_sel(
  df,
  u_model_coefs = c(-0.32, 0.59, 0.69),
  y_model_coefs = c(-2.85, 0.71, 1.63, 0.40, -0.85, 0.22),
  s_model_coefs = c(0.00, 0.74, 0.19, 0.02, -0.06, 0.02)
)

# Using u1y0_model_coefs, u0y1_model_coefs, u1y1_model_coefs, s_model_coefs
adjust_uc_om_sel(
  df,
  u1y0_model_coefs = c(-0.20, 0.62, 0.01, -0.08, 0.10, -0.15),
  u0y1_model_coefs = c(-3.28, 0.63, 1.65, 0.42, -0.85, 0.26),
  u1y1_model_coefs = c(-2.70, 1.22, 1.64, 0.32, -0.77, 0.09),
  s_model_coefs = c(0.00, 0.74, 0.19, 0.02, -0.06, 0.02)
)

}
