% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosa_plots.R
\name{rosa_plots}
\alias{rosa_plots}
\alias{image.rosa}
\alias{barplot.rosa}
\title{Plotting functions for ROSA models}
\usage{
\method{image}{rosa}(
  x,
  type = c("correlation", "residual", "order"),
  ncomp = x$ncomp,
  col = mcolors(128),
  legend = TRUE,
  mar = c(5, 6, 4, 7),
  las = 1,
  ...
)

\method{barplot}{rosa}(
  height,
  type = c("train", "CV"),
  ncomp = height$ncomp,
  col = mcolors(ncomp),
  ...
)
}
\arguments{
\item{x}{A \code{rosa} object}

\item{type}{An optional \code{character} for selecting the plot type. For \code{image.rosa} the options are: "correlation" (default), "residual" or "order". For \code{barplot.rosa} the options indicate: explained variance should be based on training data ("train") or cross-validation ("CV").}

\item{ncomp}{Integer to control the number of components to plot (if fewer than the fitted number of components).}

\item{col}{Colours used for the image and bar plot, defaulting to mcolors(128).}

\item{legend}{Logical indicating if a legend should be included (default = TRUE) for \code{image.rosa}.}

\item{mar}{Figure margins, default = c(5,6,4,7) for \code{image.rosa}.}

\item{las}{Axis text direction, default = 1 for \code{image.rosa}.}

\item{...}{Additional parameters passed to \code{loadingplot}, \code{image}, \code{axis}, \code{color.legend}, or \code{barplot}.}

\item{height}{A \code{rosa} object.}
}
\value{
No return.
}
\description{
Various plotting procedures for \code{\link{rosa}} objects.
}
\details{
Usage of the functions are shown using generics in the examples below. \code{image.rosa}
makes an image plot of each candidate score's correlation to the winner or the block-wise
response residual. These plots can be used to find alternative block selection for tweaking
the ROSA model. \code{barplot.rosa} makes barplot of block and component explained variances.
\code{loadingweightsplot} is an adaptation of \code{pls::loadingplot} to plot loading weights.
}
\examples{
data(potato)
mod <- rosa(Sensory[,1] ~ ., data = potato, ncomp = 5)
image(mod)
barplot(mod)
loadingweightplot(mod)

}
\references{
Liland, K.H., Næs, T., and Indahl, U.G. (2016). ROSA - a fast extension of partial least squares regression for multiblock data analysis. Journal of Chemometrics, 30, 651–662, doi:10.1002/cem.2824.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results in \code{\link{rosa_results}}.
}
