% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{hogsvd}
\alias{hogsvd}
\title{Higher Order Generalized SVD - HOGSVD}
\usage{
hogsvd(X)
}
\arguments{
\item{X}{\code{list} of input blocks.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a simple implementation for computing HOGSVD
}
\details{
HOGSVD is a generalisation of SVD to two or more blocks. It finds a common set
of loadings across blocks and individual sets of scores per block.
}
\examples{
data(candies)
candyList <- lapply(1:nlevels(candies$candy),function(x)candies$assessment[candies$candy==x,])
can.hogsvd <- hogsvd(candyList)
scoreplot(can.hogsvd, block=1, labels="names")

}
\references{
Ponnapalli, S. P., Saunders, M. A., Van Loan, C. F., & Alter, O. (2011). A higher-order generalized singular value decomposition for comparison of global mRNA expression from multiple organisms. PloS one, 6(12), e28072.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
