% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{ifa}
\alias{ifa}
\title{Inter-battery Factor Analysis - IFA}
\usage{
ifa(X, ncomp = 1, scale = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{X}{\code{list} of input data blocks.}

\item{ncomp}{\code{integer} number of principal components to return.}

\item{scale}{\code{logical} indicating if variables should be standardised (default=FALSE).}

\item{verbose}{\code{logical} indicating if intermediate results should be printed.}

\item{...}{additional arguments to \code{RGCCA::rgcca}.}
}
\value{
\code{multiblock} object with associated with printing, scores, loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{RGCCA::rgcca} function for computing IFA.
}
\details{
IFA rotates two matrices to align one or more factors against each other, maximising correlations.
}
\examples{
data(potato)
X <- potato$Chemical

ifa.pot  <- ifa(potato[1:2])
}
\references{
Tucker, L. R. (1958). An inter-battery method of factor analysis. Psychometrika, 23(2), 111-136.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
