% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{extended.model.frame}
\alias{extended.model.frame}
\title{Extracting the Extended Model Frame from a Formula or Fit}
\usage{
extended.model.frame(formula, data, ..., sep = ".")
}
\arguments{
\item{formula}{a model formula or terms object or an R object.}

\item{data}{a data.frame, list or environment (see \code{\link{model.frame}}).}

\item{...}{further arguments to pass to \code{\link{model.frame}}.}

\item{sep}{separator in contraction of names for interactions (default = ".").}
}
\value{
A \code{\link{data.frame}} that includes everything a \code{\link{model.frame}}
does plus interaction terms.
}
\description{
This function attempts to apply \code{\link{model.frame}} and extend the
result with columns of interactions.
}
\examples{
dat <- data.frame(Y = c(1,2,3,4,5,6), 
                  X = factor(LETTERS[c(1,1,2,2,3,3)]), 
                  W = factor(letters[c(1,2,1,2,1,2)]))
extended.model.frame(Y ~ X*W, dat)
}
