% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_subfunc.R
\name{mc_subfunc}
\alias{mc_subfunc}
\title{Ascertain GRAID functions of phrasal subconstituents}
\usage{
mc_subfunc(text, subforms = c("np", "pro", "refl", "indef"))
}
\arguments{
\item{text}{A \code{\link[data.table]{data.table}} in multicastR format,
containing minimally columns for \code{file}, GRAID function \code{gfunc},
and GRAID form \code{gform}.}

\item{subforms}{A character vector of GRAID form symbols that should be
assigned the function of the phrase they are subconstituents of.}
}
\value{
The \code{text} with an additional column \code{pfunc} combining the
  values of \code{gfunc} with functions copied to phrasal subconstituents.
}
\description{
In GRAID, noun phrase subconstituents are marked with \code{<ln>} or
\code{<rn>} for elements respectively to the left or right of the phrase
head. As, however, GRAID functions are only marked on the phrase head (with
the exception of the \code{<:poss>} function), the function of the phrase can
only directly be read off its head, not any of of its other constituents. The
\code{mc_subfunc} function finds the heads of NPs and copies their GRAID
functions to potentially referential subconstituents that - crucially - are
continguous with the phrase head in linear order. That is, if a NP is broken
up by any elements not belonging to it, this function cannot associate any of
its non-contiguous subconstituents with it. Note also that only a subset of
subconstituent glosses are assigned functions, specifically those containing
the forms in the \code{subforms} argument. By default, these are \code{<np>}
for lexical nouns (e.g \code{<ln_np>} and \code{<rn_np>}, but also
\code{<ln_pn_np>} etc.), \code{<pro>} for free pronouns, \code{<refl>} for
reflexives, and \code{<indef>} for indefinites. This list of forms can be
replaced or expanded as necessary, or left empty to match all affixed
subconstituent glosses (i.e. \code{<ln_*>} and \code{<rn_*>}, but not simple
\code{<ln>} or \code{<rn>}).
}
\seealso{
\code{\link{multicast}}
}
\keyword{internal}
